record Mapping(int no, Object content) {}
record Point(int x, int y) {}

void main() {
    var marr = new Mapping[] {
            new Mapping(1, "Text"),
            new Mapping(2, Integer.valueOf(13)),
            new Mapping(3, new Point(1, 2)),
            new Mapping(4, new Object()),
    };
    var ran = new Random();
    Mapping mt = marr[ran.nextInt(4)];

    IO.println("\nRecord- und Typmuster in einer switch-Anweisung:");
    switch(mt) {
        case Mapping(int no, String s) -> IO.println(" Zeichenfolge: " + s);
        case Mapping m -> IO.println(" Mapping no " + m.no() + ", Inhalt: " + m.content().getClass());
    };

    IO.println("\nUnbenanntes Muster:");
    switch(mt) {
        case Mapping(_, String s) ->
                IO.println(" Zeichenfolge: " + s);
        case Mapping m ->
                IO.println(" Mapping no " + m.no() + ", Inhalt: " + m.content().getClass());
    };

    IO.println("\nRecord-Typmuster in einer erweiterten switch-Anweisung:");
    switch(mt) {
        case Mapping(_, String s) when s.length() > 0 ->
                IO.println(" Zeichenfolge: " + s);
        case Mapping(_, Integer ic) ->
                IO.println(" Integer mit Wert: " + ic);
        case Mapping(_, Point(var i, _)) ->
                IO.println(" Point mit X-Koordinate: " + i);
        case Mapping m ->
                IO.println(" Mapping no " + m.no() + ", Inhalt: " + m.content().getClass());
    };

    IO.println("\nRecord-Muster in einem instanceof-Ausdruck:");
    if (mt instanceof Mapping(_, Point(var i, _)))
        IO.println(" Point mit X-Koordinate: " + i);
    else
        IO.println(" Kein Point als Inhalt");
}

